/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Date;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class User
implements ToCopyableBuilder<Builder, User> {
    private final String path;
    private final String userName;
    private final String userId;
    private final String arn;
    private final Date createDate;
    private final Date passwordLastUsed;

    private User(BuilderImpl builder) {
        this.path = builder.path;
        this.userName = builder.userName;
        this.userId = builder.userId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.passwordLastUsed = builder.passwordLastUsed;
    }

    public String path() {
        return this.path;
    }

    public String userName() {
        return this.userName;
    }

    public String userId() {
        return this.userId;
    }

    public String arn() {
        return this.arn;
    }

    public Date createDate() {
        return this.createDate;
    }

    public Date passwordLastUsed() {
        return this.passwordLastUsed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.path() == null ? 0 : this.path().hashCode());
        hashCode = 31 * hashCode + (this.userName() == null ? 0 : this.userName().hashCode());
        hashCode = 31 * hashCode + (this.userId() == null ? 0 : this.userId().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.createDate() == null ? 0 : this.createDate().hashCode());
        hashCode = 31 * hashCode + (this.passwordLastUsed() == null ? 0 : this.passwordLastUsed().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        if (other.path() == null ^ this.path() == null) {
            return false;
        }
        if (other.path() != null && !other.path().equals(this.path())) {
            return false;
        }
        if (other.userName() == null ^ this.userName() == null) {
            return false;
        }
        if (other.userName() != null && !other.userName().equals(this.userName())) {
            return false;
        }
        if (other.userId() == null ^ this.userId() == null) {
            return false;
        }
        if (other.userId() != null && !other.userId().equals(this.userId())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.createDate() == null ^ this.createDate() == null) {
            return false;
        }
        if (other.createDate() != null && !other.createDate().equals(this.createDate())) {
            return false;
        }
        if (other.passwordLastUsed() == null ^ this.passwordLastUsed() == null) {
            return false;
        }
        return other.passwordLastUsed() == null || other.passwordLastUsed().equals(this.passwordLastUsed());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.userName() != null) {
            sb.append("UserName: ").append(this.userName()).append(",");
        }
        if (this.userId() != null) {
            sb.append("UserId: ").append(this.userId()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.createDate() != null) {
            sb.append("CreateDate: ").append(this.createDate()).append(",");
        }
        if (this.passwordLastUsed() != null) {
            sb.append("PasswordLastUsed: ").append(this.passwordLastUsed()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String path;
        private String userName;
        private String userId;
        private String arn;
        private Date createDate;
        private Date passwordLastUsed;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            this.setPath(model.path);
            this.setUserName(model.userName);
            this.setUserId(model.userId);
            this.setArn(model.arn);
            this.setCreateDate(model.createDate);
            this.setPasswordLastUsed(model.passwordLastUsed);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Date getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Date createDate) {
            this.createDate = StandardMemberCopier.copy(createDate);
            return this;
        }

        public final void setCreateDate(Date createDate) {
            this.createDate = StandardMemberCopier.copy(createDate);
        }

        public final Date getPasswordLastUsed() {
            return this.passwordLastUsed;
        }

        @Override
        public final Builder passwordLastUsed(Date passwordLastUsed) {
            this.passwordLastUsed = StandardMemberCopier.copy(passwordLastUsed);
            return this;
        }

        public final void setPasswordLastUsed(Date passwordLastUsed) {
            this.passwordLastUsed = StandardMemberCopier.copy(passwordLastUsed);
        }

        @Override
        public User build() {
            return new User(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, User> {
        public Builder path(String var1);

        public Builder userName(String var1);

        public Builder userId(String var1);

        public Builder arn(String var1);

        public Builder createDate(Date var1);

        public Builder passwordLastUsed(Date var1);
    }
}

