/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.nio.ByteBuffer;
import java.util.Date;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.iam.model.User;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VirtualMFADevice
implements ToCopyableBuilder<Builder, VirtualMFADevice> {
    private final String serialNumber;
    private final ByteBuffer base32StringSeed;
    private final ByteBuffer qrCodePNG;
    private final User user;
    private final Date enableDate;

    private VirtualMFADevice(BuilderImpl builder) {
        this.serialNumber = builder.serialNumber;
        this.base32StringSeed = builder.base32StringSeed;
        this.qrCodePNG = builder.qrCodePNG;
        this.user = builder.user;
        this.enableDate = builder.enableDate;
    }

    public String serialNumber() {
        return this.serialNumber;
    }

    public ByteBuffer base32StringSeed() {
        return this.base32StringSeed;
    }

    public ByteBuffer qrCodePNG() {
        return this.qrCodePNG;
    }

    public User user() {
        return this.user;
    }

    public Date enableDate() {
        return this.enableDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.serialNumber() == null ? 0 : this.serialNumber().hashCode());
        hashCode = 31 * hashCode + (this.base32StringSeed() == null ? 0 : this.base32StringSeed().hashCode());
        hashCode = 31 * hashCode + (this.qrCodePNG() == null ? 0 : this.qrCodePNG().hashCode());
        hashCode = 31 * hashCode + (this.user() == null ? 0 : this.user().hashCode());
        hashCode = 31 * hashCode + (this.enableDate() == null ? 0 : this.enableDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualMFADevice)) {
            return false;
        }
        VirtualMFADevice other = (VirtualMFADevice)obj;
        if (other.serialNumber() == null ^ this.serialNumber() == null) {
            return false;
        }
        if (other.serialNumber() != null && !other.serialNumber().equals(this.serialNumber())) {
            return false;
        }
        if (other.base32StringSeed() == null ^ this.base32StringSeed() == null) {
            return false;
        }
        if (other.base32StringSeed() != null && !other.base32StringSeed().equals(this.base32StringSeed())) {
            return false;
        }
        if (other.qrCodePNG() == null ^ this.qrCodePNG() == null) {
            return false;
        }
        if (other.qrCodePNG() != null && !other.qrCodePNG().equals(this.qrCodePNG())) {
            return false;
        }
        if (other.user() == null ^ this.user() == null) {
            return false;
        }
        if (other.user() != null && !other.user().equals(this.user())) {
            return false;
        }
        if (other.enableDate() == null ^ this.enableDate() == null) {
            return false;
        }
        return other.enableDate() == null || other.enableDate().equals(this.enableDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.serialNumber() != null) {
            sb.append("SerialNumber: ").append(this.serialNumber()).append(",");
        }
        if (this.base32StringSeed() != null) {
            sb.append("Base32StringSeed: ").append(this.base32StringSeed()).append(",");
        }
        if (this.qrCodePNG() != null) {
            sb.append("QRCodePNG: ").append(this.qrCodePNG()).append(",");
        }
        if (this.user() != null) {
            sb.append("User: ").append(this.user()).append(",");
        }
        if (this.enableDate() != null) {
            sb.append("EnableDate: ").append(this.enableDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String serialNumber;
        private ByteBuffer base32StringSeed;
        private ByteBuffer qrCodePNG;
        private User user;
        private Date enableDate;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualMFADevice model) {
            this.setSerialNumber(model.serialNumber);
            this.setBase32StringSeed(model.base32StringSeed);
            this.setQRCodePNG(model.qrCodePNG);
            this.setUser(model.user);
            this.setEnableDate(model.enableDate);
        }

        public final String getSerialNumber() {
            return this.serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public final ByteBuffer getBase32StringSeed() {
            return this.base32StringSeed;
        }

        @Override
        public final Builder base32StringSeed(ByteBuffer base32StringSeed) {
            this.base32StringSeed = StandardMemberCopier.copy(base32StringSeed);
            return this;
        }

        public final void setBase32StringSeed(ByteBuffer base32StringSeed) {
            this.base32StringSeed = StandardMemberCopier.copy(base32StringSeed);
        }

        public final ByteBuffer getQRCodePNG() {
            return this.qrCodePNG;
        }

        @Override
        public final Builder qrCodePNG(ByteBuffer qrCodePNG) {
            this.qrCodePNG = StandardMemberCopier.copy(qrCodePNG);
            return this;
        }

        public final void setQRCodePNG(ByteBuffer qrCodePNG) {
            this.qrCodePNG = StandardMemberCopier.copy(qrCodePNG);
        }

        public final User getUser() {
            return this.user;
        }

        @Override
        public final Builder user(User user) {
            this.user = user;
            return this;
        }

        public final void setUser(User user) {
            this.user = user;
        }

        public final Date getEnableDate() {
            return this.enableDate;
        }

        @Override
        public final Builder enableDate(Date enableDate) {
            this.enableDate = StandardMemberCopier.copy(enableDate);
            return this;
        }

        public final void setEnableDate(Date enableDate) {
            this.enableDate = StandardMemberCopier.copy(enableDate);
        }

        @Override
        public VirtualMFADevice build() {
            return new VirtualMFADevice(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VirtualMFADevice> {
        public Builder serialNumber(String var1);

        public Builder base32StringSeed(ByteBuffer var1);

        public Builder qrCodePNG(ByteBuffer var1);

        public Builder user(User var1);

        public Builder enableDate(Date var1);
    }
}

