/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.AddUserToGroupRequest;
import software.amazon.awssdk.util.StringUtils;

public class AddUserToGroupRequestMarshaller
implements Marshaller<Request<AddUserToGroupRequest>, AddUserToGroupRequest> {
    @Override
    public Request<AddUserToGroupRequest> marshall(AddUserToGroupRequest addUserToGroupRequest) {
        if (addUserToGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AddUserToGroupRequest> request = new DefaultRequest<AddUserToGroupRequest>(addUserToGroupRequest, "IAMClient");
        request.addParameter("Action", "AddUserToGroup");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (addUserToGroupRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString(addUserToGroupRequest.groupName()));
        }
        if (addUserToGroupRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString(addUserToGroupRequest.userName()));
        }
        return request;
    }
}

