/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.AttachRolePolicyRequest;
import software.amazon.awssdk.util.StringUtils;

public class AttachRolePolicyRequestMarshaller
implements Marshaller<Request<AttachRolePolicyRequest>, AttachRolePolicyRequest> {
    @Override
    public Request<AttachRolePolicyRequest> marshall(AttachRolePolicyRequest attachRolePolicyRequest) {
        if (attachRolePolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AttachRolePolicyRequest> request = new DefaultRequest<AttachRolePolicyRequest>(attachRolePolicyRequest, "IAMClient");
        request.addParameter("Action", "AttachRolePolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachRolePolicyRequest.roleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString(attachRolePolicyRequest.roleName()));
        }
        if (attachRolePolicyRequest.policyArn() != null) {
            request.addParameter("PolicyArn", StringUtils.fromString(attachRolePolicyRequest.policyArn()));
        }
        return request;
    }
}

