/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iam.model.ContextEntry;

public class ContextEntryUnmarshaller
implements Unmarshaller<ContextEntry, StaxUnmarshallerContext> {
    private static ContextEntryUnmarshaller INSTANCE;

    @Override
    public ContextEntry unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ContextEntry.Builder contextEntry = ContextEntry.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ContextKeyName", targetDepth)) {
                    contextEntry.contextKeyName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ContextKeyValues", targetDepth)) {
                    contextEntry.contextKeyValues(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("ContextKeyValues/member", targetDepth)) {
                    contextEntry.contextKeyValues(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ContextKeyType", targetDepth)) continue;
                contextEntry.contextKeyType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ContextEntry)contextEntry.build();
    }

    public static ContextEntryUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ContextEntryUnmarshaller();
        }
        return INSTANCE;
    }
}

