/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.CreateLoginProfileRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateLoginProfileRequestMarshaller
implements Marshaller<Request<CreateLoginProfileRequest>, CreateLoginProfileRequest> {
    @Override
    public Request<CreateLoginProfileRequest> marshall(CreateLoginProfileRequest createLoginProfileRequest) {
        if (createLoginProfileRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateLoginProfileRequest> request = new DefaultRequest<CreateLoginProfileRequest>(createLoginProfileRequest, "IAMClient");
        request.addParameter("Action", "CreateLoginProfile");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLoginProfileRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString(createLoginProfileRequest.userName()));
        }
        if (createLoginProfileRequest.password() != null) {
            request.addParameter("Password", StringUtils.fromString(createLoginProfileRequest.password()));
        }
        if (createLoginProfileRequest.passwordResetRequired() != null) {
            request.addParameter("PasswordResetRequired", StringUtils.fromBoolean(createLoginProfileRequest.passwordResetRequired()));
        }
        return request;
    }
}

