/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.CreateOpenIDConnectProviderRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateOpenIDConnectProviderRequestMarshaller
implements Marshaller<Request<CreateOpenIDConnectProviderRequest>, CreateOpenIDConnectProviderRequest> {
    @Override
    public Request<CreateOpenIDConnectProviderRequest> marshall(CreateOpenIDConnectProviderRequest createOpenIDConnectProviderRequest) {
        SdkInternalList thumbprintListList;
        SdkInternalList clientIDListList;
        if (createOpenIDConnectProviderRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateOpenIDConnectProviderRequest> request = new DefaultRequest<CreateOpenIDConnectProviderRequest>(createOpenIDConnectProviderRequest, "IAMClient");
        request.addParameter("Action", "CreateOpenIDConnectProvider");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createOpenIDConnectProviderRequest.url() != null) {
            request.addParameter("Url", StringUtils.fromString(createOpenIDConnectProviderRequest.url()));
        }
        if (!(clientIDListList = (SdkInternalList)createOpenIDConnectProviderRequest.clientIDList()).isEmpty() || !clientIDListList.isAutoConstruct()) {
            int clientIDListListIndex = 1;
            for (String clientIDListListValue : clientIDListList) {
                if (clientIDListListValue != null) {
                    request.addParameter("ClientIDList.member." + clientIDListListIndex, StringUtils.fromString(clientIDListListValue));
                }
                ++clientIDListListIndex;
            }
        }
        if (!(thumbprintListList = (SdkInternalList)createOpenIDConnectProviderRequest.thumbprintList()).isEmpty() || !thumbprintListList.isAutoConstruct()) {
            int thumbprintListListIndex = 1;
            for (String thumbprintListListValue : thumbprintListList) {
                if (thumbprintListListValue != null) {
                    request.addParameter("ThumbprintList.member." + thumbprintListListIndex, StringUtils.fromString(thumbprintListListValue));
                }
                ++thumbprintListListIndex;
            }
        }
        return request;
    }
}

