/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.CreatePolicyVersionRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreatePolicyVersionRequestMarshaller
implements Marshaller<Request<CreatePolicyVersionRequest>, CreatePolicyVersionRequest> {
    @Override
    public Request<CreatePolicyVersionRequest> marshall(CreatePolicyVersionRequest createPolicyVersionRequest) {
        if (createPolicyVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreatePolicyVersionRequest> request = new DefaultRequest<CreatePolicyVersionRequest>(createPolicyVersionRequest, "IAMClient");
        request.addParameter("Action", "CreatePolicyVersion");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createPolicyVersionRequest.policyArn() != null) {
            request.addParameter("PolicyArn", StringUtils.fromString(createPolicyVersionRequest.policyArn()));
        }
        if (createPolicyVersionRequest.policyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString(createPolicyVersionRequest.policyDocument()));
        }
        if (createPolicyVersionRequest.setAsDefault() != null) {
            request.addParameter("SetAsDefault", StringUtils.fromBoolean(createPolicyVersionRequest.setAsDefault()));
        }
        return request;
    }
}

