/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateServiceSpecificCredentialRequestMarshaller
implements Marshaller<Request<CreateServiceSpecificCredentialRequest>, CreateServiceSpecificCredentialRequest> {
    @Override
    public Request<CreateServiceSpecificCredentialRequest> marshall(CreateServiceSpecificCredentialRequest createServiceSpecificCredentialRequest) {
        if (createServiceSpecificCredentialRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateServiceSpecificCredentialRequest> request = new DefaultRequest<CreateServiceSpecificCredentialRequest>(createServiceSpecificCredentialRequest, "IAMClient");
        request.addParameter("Action", "CreateServiceSpecificCredential");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createServiceSpecificCredentialRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString(createServiceSpecificCredentialRequest.userName()));
        }
        if (createServiceSpecificCredentialRequest.serviceName() != null) {
            request.addParameter("ServiceName", StringUtils.fromString(createServiceSpecificCredentialRequest.serviceName()));
        }
        return request;
    }
}

