/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.CreateUserRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateUserRequestMarshaller
implements Marshaller<Request<CreateUserRequest>, CreateUserRequest> {
    @Override
    public Request<CreateUserRequest> marshall(CreateUserRequest createUserRequest) {
        if (createUserRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateUserRequest> request = new DefaultRequest<CreateUserRequest>(createUserRequest, "IAMClient");
        request.addParameter("Action", "CreateUser");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createUserRequest.path() != null) {
            request.addParameter("Path", StringUtils.fromString(createUserRequest.path()));
        }
        if (createUserRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString(createUserRequest.userName()));
        }
        return request;
    }
}

