/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.DeleteGroupRequest;
import software.amazon.awssdk.util.StringUtils;

public class DeleteGroupRequestMarshaller
implements Marshaller<Request<DeleteGroupRequest>, DeleteGroupRequest> {
    @Override
    public Request<DeleteGroupRequest> marshall(DeleteGroupRequest deleteGroupRequest) {
        if (deleteGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteGroupRequest> request = new DefaultRequest<DeleteGroupRequest>(deleteGroupRequest, "IAMClient");
        request.addParameter("Action", "DeleteGroup");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteGroupRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString(deleteGroupRequest.groupName()));
        }
        return request;
    }
}

