/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.DeletePolicyVersionRequest;
import software.amazon.awssdk.util.StringUtils;

public class DeletePolicyVersionRequestMarshaller
implements Marshaller<Request<DeletePolicyVersionRequest>, DeletePolicyVersionRequest> {
    @Override
    public Request<DeletePolicyVersionRequest> marshall(DeletePolicyVersionRequest deletePolicyVersionRequest) {
        if (deletePolicyVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeletePolicyVersionRequest> request = new DefaultRequest<DeletePolicyVersionRequest>(deletePolicyVersionRequest, "IAMClient");
        request.addParameter("Action", "DeletePolicyVersion");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (deletePolicyVersionRequest.policyArn() != null) {
            request.addParameter("PolicyArn", StringUtils.fromString(deletePolicyVersionRequest.policyArn()));
        }
        if (deletePolicyVersionRequest.versionId() != null) {
            request.addParameter("VersionId", StringUtils.fromString(deletePolicyVersionRequest.versionId()));
        }
        return request;
    }
}

