/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.DeleteSSHPublicKeyRequest;
import software.amazon.awssdk.util.StringUtils;

public class DeleteSSHPublicKeyRequestMarshaller
implements Marshaller<Request<DeleteSSHPublicKeyRequest>, DeleteSSHPublicKeyRequest> {
    @Override
    public Request<DeleteSSHPublicKeyRequest> marshall(DeleteSSHPublicKeyRequest deleteSSHPublicKeyRequest) {
        if (deleteSSHPublicKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteSSHPublicKeyRequest> request = new DefaultRequest<DeleteSSHPublicKeyRequest>(deleteSSHPublicKeyRequest, "IAMClient");
        request.addParameter("Action", "DeleteSSHPublicKey");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteSSHPublicKeyRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString(deleteSSHPublicKeyRequest.userName()));
        }
        if (deleteSSHPublicKeyRequest.sshPublicKeyId() != null) {
            request.addParameter("SSHPublicKeyId", StringUtils.fromString(deleteSSHPublicKeyRequest.sshPublicKeyId()));
        }
        return request;
    }
}

