/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.DeleteUserRequest;
import software.amazon.awssdk.util.StringUtils;

public class DeleteUserRequestMarshaller
implements Marshaller<Request<DeleteUserRequest>, DeleteUserRequest> {
    @Override
    public Request<DeleteUserRequest> marshall(DeleteUserRequest deleteUserRequest) {
        if (deleteUserRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteUserRequest> request = new DefaultRequest<DeleteUserRequest>(deleteUserRequest, "IAMClient");
        request.addParameter("Action", "DeleteUser");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteUserRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString(deleteUserRequest.userName()));
        }
        return request;
    }
}

