/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.EnableMFADeviceRequest;
import software.amazon.awssdk.util.StringUtils;

public class EnableMFADeviceRequestMarshaller
implements Marshaller<Request<EnableMFADeviceRequest>, EnableMFADeviceRequest> {
    @Override
    public Request<EnableMFADeviceRequest> marshall(EnableMFADeviceRequest enableMFADeviceRequest) {
        if (enableMFADeviceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<EnableMFADeviceRequest> request = new DefaultRequest<EnableMFADeviceRequest>(enableMFADeviceRequest, "IAMClient");
        request.addParameter("Action", "EnableMFADevice");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (enableMFADeviceRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString(enableMFADeviceRequest.userName()));
        }
        if (enableMFADeviceRequest.serialNumber() != null) {
            request.addParameter("SerialNumber", StringUtils.fromString(enableMFADeviceRequest.serialNumber()));
        }
        if (enableMFADeviceRequest.authenticationCode1() != null) {
            request.addParameter("AuthenticationCode1", StringUtils.fromString(enableMFADeviceRequest.authenticationCode1()));
        }
        if (enableMFADeviceRequest.authenticationCode2() != null) {
            request.addParameter("AuthenticationCode2", StringUtils.fromString(enableMFADeviceRequest.authenticationCode2()));
        }
        return request;
    }
}

