/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.GetGroupPolicyRequest;
import software.amazon.awssdk.util.StringUtils;

public class GetGroupPolicyRequestMarshaller
implements Marshaller<Request<GetGroupPolicyRequest>, GetGroupPolicyRequest> {
    @Override
    public Request<GetGroupPolicyRequest> marshall(GetGroupPolicyRequest getGroupPolicyRequest) {
        if (getGroupPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetGroupPolicyRequest> request = new DefaultRequest<GetGroupPolicyRequest>(getGroupPolicyRequest, "IAMClient");
        request.addParameter("Action", "GetGroupPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (getGroupPolicyRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString(getGroupPolicyRequest.groupName()));
        }
        if (getGroupPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString(getGroupPolicyRequest.policyName()));
        }
        return request;
    }
}

