/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.GetGroupRequest;
import software.amazon.awssdk.util.StringUtils;

public class GetGroupRequestMarshaller
implements Marshaller<Request<GetGroupRequest>, GetGroupRequest> {
    @Override
    public Request<GetGroupRequest> marshall(GetGroupRequest getGroupRequest) {
        if (getGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetGroupRequest> request = new DefaultRequest<GetGroupRequest>(getGroupRequest, "IAMClient");
        request.addParameter("Action", "GetGroup");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (getGroupRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString(getGroupRequest.groupName()));
        }
        if (getGroupRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString(getGroupRequest.marker()));
        }
        if (getGroupRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger(getGroupRequest.maxItems()));
        }
        return request;
    }
}

