/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.GetInstanceProfileRequest;
import software.amazon.awssdk.util.StringUtils;

public class GetInstanceProfileRequestMarshaller
implements Marshaller<Request<GetInstanceProfileRequest>, GetInstanceProfileRequest> {
    @Override
    public Request<GetInstanceProfileRequest> marshall(GetInstanceProfileRequest getInstanceProfileRequest) {
        if (getInstanceProfileRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetInstanceProfileRequest> request = new DefaultRequest<GetInstanceProfileRequest>(getInstanceProfileRequest, "IAMClient");
        request.addParameter("Action", "GetInstanceProfile");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (getInstanceProfileRequest.instanceProfileName() != null) {
            request.addParameter("InstanceProfileName", StringUtils.fromString(getInstanceProfileRequest.instanceProfileName()));
        }
        return request;
    }
}

