/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.GetPolicyVersionRequest;
import software.amazon.awssdk.util.StringUtils;

public class GetPolicyVersionRequestMarshaller
implements Marshaller<Request<GetPolicyVersionRequest>, GetPolicyVersionRequest> {
    @Override
    public Request<GetPolicyVersionRequest> marshall(GetPolicyVersionRequest getPolicyVersionRequest) {
        if (getPolicyVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetPolicyVersionRequest> request = new DefaultRequest<GetPolicyVersionRequest>(getPolicyVersionRequest, "IAMClient");
        request.addParameter("Action", "GetPolicyVersion");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (getPolicyVersionRequest.policyArn() != null) {
            request.addParameter("PolicyArn", StringUtils.fromString(getPolicyVersionRequest.policyArn()));
        }
        if (getPolicyVersionRequest.versionId() != null) {
            request.addParameter("VersionId", StringUtils.fromString(getPolicyVersionRequest.versionId()));
        }
        return request;
    }
}

