/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.GetRolePolicyRequest;
import software.amazon.awssdk.util.StringUtils;

public class GetRolePolicyRequestMarshaller
implements Marshaller<Request<GetRolePolicyRequest>, GetRolePolicyRequest> {
    @Override
    public Request<GetRolePolicyRequest> marshall(GetRolePolicyRequest getRolePolicyRequest) {
        if (getRolePolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetRolePolicyRequest> request = new DefaultRequest<GetRolePolicyRequest>(getRolePolicyRequest, "IAMClient");
        request.addParameter("Action", "GetRolePolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (getRolePolicyRequest.roleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString(getRolePolicyRequest.roleName()));
        }
        if (getRolePolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString(getRolePolicyRequest.policyName()));
        }
        return request;
    }
}

