/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.GetSSHPublicKeyRequest;
import software.amazon.awssdk.util.StringUtils;

public class GetSSHPublicKeyRequestMarshaller
implements Marshaller<Request<GetSSHPublicKeyRequest>, GetSSHPublicKeyRequest> {
    @Override
    public Request<GetSSHPublicKeyRequest> marshall(GetSSHPublicKeyRequest getSSHPublicKeyRequest) {
        if (getSSHPublicKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetSSHPublicKeyRequest> request = new DefaultRequest<GetSSHPublicKeyRequest>(getSSHPublicKeyRequest, "IAMClient");
        request.addParameter("Action", "GetSSHPublicKey");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (getSSHPublicKeyRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString(getSSHPublicKeyRequest.userName()));
        }
        if (getSSHPublicKeyRequest.sshPublicKeyId() != null) {
            request.addParameter("SSHPublicKeyId", StringUtils.fromString(getSSHPublicKeyRequest.sshPublicKeyId()));
        }
        if (getSSHPublicKeyRequest.encoding() != null) {
            request.addParameter("Encoding", StringUtils.fromString(getSSHPublicKeyRequest.encoding()));
        }
        return request;
    }
}

