/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListEntitiesForPolicyRequestMarshaller
implements Marshaller<Request<ListEntitiesForPolicyRequest>, ListEntitiesForPolicyRequest> {
    @Override
    public Request<ListEntitiesForPolicyRequest> marshall(ListEntitiesForPolicyRequest listEntitiesForPolicyRequest) {
        if (listEntitiesForPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListEntitiesForPolicyRequest> request = new DefaultRequest<ListEntitiesForPolicyRequest>(listEntitiesForPolicyRequest, "IAMClient");
        request.addParameter("Action", "ListEntitiesForPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listEntitiesForPolicyRequest.policyArn() != null) {
            request.addParameter("PolicyArn", StringUtils.fromString(listEntitiesForPolicyRequest.policyArn()));
        }
        if (listEntitiesForPolicyRequest.entityFilter() != null) {
            request.addParameter("EntityFilter", StringUtils.fromString(listEntitiesForPolicyRequest.entityFilter()));
        }
        if (listEntitiesForPolicyRequest.pathPrefix() != null) {
            request.addParameter("PathPrefix", StringUtils.fromString(listEntitiesForPolicyRequest.pathPrefix()));
        }
        if (listEntitiesForPolicyRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listEntitiesForPolicyRequest.marker()));
        }
        if (listEntitiesForPolicyRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger(listEntitiesForPolicyRequest.maxItems()));
        }
        return request;
    }
}

