/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListGroupPoliciesRequestMarshaller
implements Marshaller<Request<ListGroupPoliciesRequest>, ListGroupPoliciesRequest> {
    @Override
    public Request<ListGroupPoliciesRequest> marshall(ListGroupPoliciesRequest listGroupPoliciesRequest) {
        if (listGroupPoliciesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListGroupPoliciesRequest> request = new DefaultRequest<ListGroupPoliciesRequest>(listGroupPoliciesRequest, "IAMClient");
        request.addParameter("Action", "ListGroupPolicies");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listGroupPoliciesRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString(listGroupPoliciesRequest.groupName()));
        }
        if (listGroupPoliciesRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listGroupPoliciesRequest.marker()));
        }
        if (listGroupPoliciesRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger(listGroupPoliciesRequest.maxItems()));
        }
        return request;
    }
}

