/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.ListGroupsRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListGroupsRequestMarshaller
implements Marshaller<Request<ListGroupsRequest>, ListGroupsRequest> {
    @Override
    public Request<ListGroupsRequest> marshall(ListGroupsRequest listGroupsRequest) {
        if (listGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListGroupsRequest> request = new DefaultRequest<ListGroupsRequest>(listGroupsRequest, "IAMClient");
        request.addParameter("Action", "ListGroups");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listGroupsRequest.pathPrefix() != null) {
            request.addParameter("PathPrefix", StringUtils.fromString(listGroupsRequest.pathPrefix()));
        }
        if (listGroupsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listGroupsRequest.marker()));
        }
        if (listGroupsRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger(listGroupsRequest.maxItems()));
        }
        return request;
    }
}

