/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListInstanceProfilesForRoleRequestMarshaller
implements Marshaller<Request<ListInstanceProfilesForRoleRequest>, ListInstanceProfilesForRoleRequest> {
    @Override
    public Request<ListInstanceProfilesForRoleRequest> marshall(ListInstanceProfilesForRoleRequest listInstanceProfilesForRoleRequest) {
        if (listInstanceProfilesForRoleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListInstanceProfilesForRoleRequest> request = new DefaultRequest<ListInstanceProfilesForRoleRequest>(listInstanceProfilesForRoleRequest, "IAMClient");
        request.addParameter("Action", "ListInstanceProfilesForRole");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listInstanceProfilesForRoleRequest.roleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString(listInstanceProfilesForRoleRequest.roleName()));
        }
        if (listInstanceProfilesForRoleRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listInstanceProfilesForRoleRequest.marker()));
        }
        if (listInstanceProfilesForRoleRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger(listInstanceProfilesForRoleRequest.maxItems()));
        }
        return request;
    }
}

