/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.ListMFADevicesRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListMFADevicesRequestMarshaller
implements Marshaller<Request<ListMFADevicesRequest>, ListMFADevicesRequest> {
    @Override
    public Request<ListMFADevicesRequest> marshall(ListMFADevicesRequest listMFADevicesRequest) {
        if (listMFADevicesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListMFADevicesRequest> request = new DefaultRequest<ListMFADevicesRequest>(listMFADevicesRequest, "IAMClient");
        request.addParameter("Action", "ListMFADevices");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listMFADevicesRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString(listMFADevicesRequest.userName()));
        }
        if (listMFADevicesRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listMFADevicesRequest.marker()));
        }
        if (listMFADevicesRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger(listMFADevicesRequest.maxItems()));
        }
        return request;
    }
}

