/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.ListPoliciesRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListPoliciesRequestMarshaller
implements Marshaller<Request<ListPoliciesRequest>, ListPoliciesRequest> {
    @Override
    public Request<ListPoliciesRequest> marshall(ListPoliciesRequest listPoliciesRequest) {
        if (listPoliciesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListPoliciesRequest> request = new DefaultRequest<ListPoliciesRequest>(listPoliciesRequest, "IAMClient");
        request.addParameter("Action", "ListPolicies");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listPoliciesRequest.scope() != null) {
            request.addParameter("Scope", StringUtils.fromString(listPoliciesRequest.scope()));
        }
        if (listPoliciesRequest.onlyAttached() != null) {
            request.addParameter("OnlyAttached", StringUtils.fromBoolean(listPoliciesRequest.onlyAttached()));
        }
        if (listPoliciesRequest.pathPrefix() != null) {
            request.addParameter("PathPrefix", StringUtils.fromString(listPoliciesRequest.pathPrefix()));
        }
        if (listPoliciesRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listPoliciesRequest.marker()));
        }
        if (listPoliciesRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger(listPoliciesRequest.maxItems()));
        }
        return request;
    }
}

