/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.ListSSHPublicKeysRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListSSHPublicKeysRequestMarshaller
implements Marshaller<Request<ListSSHPublicKeysRequest>, ListSSHPublicKeysRequest> {
    @Override
    public Request<ListSSHPublicKeysRequest> marshall(ListSSHPublicKeysRequest listSSHPublicKeysRequest) {
        if (listSSHPublicKeysRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListSSHPublicKeysRequest> request = new DefaultRequest<ListSSHPublicKeysRequest>(listSSHPublicKeysRequest, "IAMClient");
        request.addParameter("Action", "ListSSHPublicKeys");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listSSHPublicKeysRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString(listSSHPublicKeysRequest.userName()));
        }
        if (listSSHPublicKeysRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listSSHPublicKeysRequest.marker()));
        }
        if (listSSHPublicKeysRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger(listSSHPublicKeysRequest.maxItems()));
        }
        return request;
    }
}

