/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.ListServiceSpecificCredentialsRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListServiceSpecificCredentialsRequestMarshaller
implements Marshaller<Request<ListServiceSpecificCredentialsRequest>, ListServiceSpecificCredentialsRequest> {
    @Override
    public Request<ListServiceSpecificCredentialsRequest> marshall(ListServiceSpecificCredentialsRequest listServiceSpecificCredentialsRequest) {
        if (listServiceSpecificCredentialsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListServiceSpecificCredentialsRequest> request = new DefaultRequest<ListServiceSpecificCredentialsRequest>(listServiceSpecificCredentialsRequest, "IAMClient");
        request.addParameter("Action", "ListServiceSpecificCredentials");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listServiceSpecificCredentialsRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString(listServiceSpecificCredentialsRequest.userName()));
        }
        if (listServiceSpecificCredentialsRequest.serviceName() != null) {
            request.addParameter("ServiceName", StringUtils.fromString(listServiceSpecificCredentialsRequest.serviceName()));
        }
        return request;
    }
}

