/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.ListUserPoliciesRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListUserPoliciesRequestMarshaller
implements Marshaller<Request<ListUserPoliciesRequest>, ListUserPoliciesRequest> {
    @Override
    public Request<ListUserPoliciesRequest> marshall(ListUserPoliciesRequest listUserPoliciesRequest) {
        if (listUserPoliciesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListUserPoliciesRequest> request = new DefaultRequest<ListUserPoliciesRequest>(listUserPoliciesRequest, "IAMClient");
        request.addParameter("Action", "ListUserPolicies");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (listUserPoliciesRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString(listUserPoliciesRequest.userName()));
        }
        if (listUserPoliciesRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString(listUserPoliciesRequest.marker()));
        }
        if (listUserPoliciesRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger(listUserPoliciesRequest.maxItems()));
        }
        return request;
    }
}

