/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iam.model.PasswordPolicy;

public class PasswordPolicyUnmarshaller
implements Unmarshaller<PasswordPolicy, StaxUnmarshallerContext> {
    private static PasswordPolicyUnmarshaller INSTANCE;

    @Override
    public PasswordPolicy unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        PasswordPolicy.Builder passwordPolicy = PasswordPolicy.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("MinimumPasswordLength", targetDepth)) {
                    passwordPolicy.minimumPasswordLength(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RequireSymbols", targetDepth)) {
                    passwordPolicy.requireSymbols(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RequireNumbers", targetDepth)) {
                    passwordPolicy.requireNumbers(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RequireUppercaseCharacters", targetDepth)) {
                    passwordPolicy.requireUppercaseCharacters(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RequireLowercaseCharacters", targetDepth)) {
                    passwordPolicy.requireLowercaseCharacters(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AllowUsersToChangePassword", targetDepth)) {
                    passwordPolicy.allowUsersToChangePassword(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ExpirePasswords", targetDepth)) {
                    passwordPolicy.expirePasswords(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxPasswordAge", targetDepth)) {
                    passwordPolicy.maxPasswordAge(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PasswordReusePrevention", targetDepth)) {
                    passwordPolicy.passwordReusePrevention(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("HardExpiry", targetDepth)) continue;
                passwordPolicy.hardExpiry(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (PasswordPolicy)passwordPolicy.build();
    }

    public static PasswordPolicyUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PasswordPolicyUnmarshaller();
        }
        return INSTANCE;
    }
}

