/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iam.model.PolicyVersion;

public class PolicyVersionUnmarshaller
implements Unmarshaller<PolicyVersion, StaxUnmarshallerContext> {
    private static PolicyVersionUnmarshaller INSTANCE;

    @Override
    public PolicyVersion unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        PolicyVersion.Builder policyVersion = PolicyVersion.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Document", targetDepth)) {
                    policyVersion.document(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VersionId", targetDepth)) {
                    policyVersion.versionId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IsDefaultVersion", targetDepth)) {
                    policyVersion.isDefaultVersion(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CreateDate", targetDepth)) continue;
                policyVersion.createDate(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (PolicyVersion)policyVersion.build();
    }

    public static PolicyVersionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PolicyVersionUnmarshaller();
        }
        return INSTANCE;
    }
}

