/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.PutRolePolicyRequest;
import software.amazon.awssdk.util.StringUtils;

public class PutRolePolicyRequestMarshaller
implements Marshaller<Request<PutRolePolicyRequest>, PutRolePolicyRequest> {
    @Override
    public Request<PutRolePolicyRequest> marshall(PutRolePolicyRequest putRolePolicyRequest) {
        if (putRolePolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutRolePolicyRequest> request = new DefaultRequest<PutRolePolicyRequest>(putRolePolicyRequest, "IAMClient");
        request.addParameter("Action", "PutRolePolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (putRolePolicyRequest.roleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString(putRolePolicyRequest.roleName()));
        }
        if (putRolePolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString(putRolePolicyRequest.policyName()));
        }
        if (putRolePolicyRequest.policyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString(putRolePolicyRequest.policyDocument()));
        }
        return request;
    }
}

