/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.ResetServiceSpecificCredentialRequest;
import software.amazon.awssdk.util.StringUtils;

public class ResetServiceSpecificCredentialRequestMarshaller
implements Marshaller<Request<ResetServiceSpecificCredentialRequest>, ResetServiceSpecificCredentialRequest> {
    @Override
    public Request<ResetServiceSpecificCredentialRequest> marshall(ResetServiceSpecificCredentialRequest resetServiceSpecificCredentialRequest) {
        if (resetServiceSpecificCredentialRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ResetServiceSpecificCredentialRequest> request = new DefaultRequest<ResetServiceSpecificCredentialRequest>(resetServiceSpecificCredentialRequest, "IAMClient");
        request.addParameter("Action", "ResetServiceSpecificCredential");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (resetServiceSpecificCredentialRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString(resetServiceSpecificCredentialRequest.userName()));
        }
        if (resetServiceSpecificCredentialRequest.serviceSpecificCredentialId() != null) {
            request.addParameter("ServiceSpecificCredentialId", StringUtils.fromString(resetServiceSpecificCredentialRequest.serviceSpecificCredentialId()));
        }
        return request;
    }
}

