/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.ResyncMFADeviceRequest;
import software.amazon.awssdk.util.StringUtils;

public class ResyncMFADeviceRequestMarshaller
implements Marshaller<Request<ResyncMFADeviceRequest>, ResyncMFADeviceRequest> {
    @Override
    public Request<ResyncMFADeviceRequest> marshall(ResyncMFADeviceRequest resyncMFADeviceRequest) {
        if (resyncMFADeviceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ResyncMFADeviceRequest> request = new DefaultRequest<ResyncMFADeviceRequest>(resyncMFADeviceRequest, "IAMClient");
        request.addParameter("Action", "ResyncMFADevice");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (resyncMFADeviceRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString(resyncMFADeviceRequest.userName()));
        }
        if (resyncMFADeviceRequest.serialNumber() != null) {
            request.addParameter("SerialNumber", StringUtils.fromString(resyncMFADeviceRequest.serialNumber()));
        }
        if (resyncMFADeviceRequest.authenticationCode1() != null) {
            request.addParameter("AuthenticationCode1", StringUtils.fromString(resyncMFADeviceRequest.authenticationCode1()));
        }
        if (resyncMFADeviceRequest.authenticationCode2() != null) {
            request.addParameter("AuthenticationCode2", StringUtils.fromString(resyncMFADeviceRequest.authenticationCode2()));
        }
        return request;
    }
}

