/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.ContextEntry;
import software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyRequest;
import software.amazon.awssdk.util.StringUtils;

public class SimulatePrincipalPolicyRequestMarshaller
implements Marshaller<Request<SimulatePrincipalPolicyRequest>, SimulatePrincipalPolicyRequest> {
    @Override
    public Request<SimulatePrincipalPolicyRequest> marshall(SimulatePrincipalPolicyRequest simulatePrincipalPolicyRequest) {
        SdkInternalList contextEntriesList;
        SdkInternalList resourceArnsList;
        SdkInternalList actionNamesList;
        SdkInternalList policyInputListList;
        if (simulatePrincipalPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SimulatePrincipalPolicyRequest> request = new DefaultRequest<SimulatePrincipalPolicyRequest>(simulatePrincipalPolicyRequest, "IAMClient");
        request.addParameter("Action", "SimulatePrincipalPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (simulatePrincipalPolicyRequest.policySourceArn() != null) {
            request.addParameter("PolicySourceArn", StringUtils.fromString(simulatePrincipalPolicyRequest.policySourceArn()));
        }
        if (!(policyInputListList = (SdkInternalList)simulatePrincipalPolicyRequest.policyInputList()).isEmpty() || !policyInputListList.isAutoConstruct()) {
            int policyInputListListIndex = 1;
            for (Object policyInputListListValue : policyInputListList) {
                if (policyInputListListValue != null) {
                    request.addParameter("PolicyInputList.member." + policyInputListListIndex, StringUtils.fromString((String)policyInputListListValue));
                }
                ++policyInputListListIndex;
            }
        }
        if (!(actionNamesList = (SdkInternalList)simulatePrincipalPolicyRequest.actionNames()).isEmpty() || !actionNamesList.isAutoConstruct()) {
            int actionNamesListIndex = 1;
            for (Object actionNamesListValue : actionNamesList) {
                if (actionNamesListValue != null) {
                    request.addParameter("ActionNames.member." + actionNamesListIndex, StringUtils.fromString((String)actionNamesListValue));
                }
                ++actionNamesListIndex;
            }
        }
        if (!(resourceArnsList = (SdkInternalList)simulatePrincipalPolicyRequest.resourceArns()).isEmpty() || !resourceArnsList.isAutoConstruct()) {
            int resourceArnsListIndex = 1;
            for (String resourceArnsListValue : resourceArnsList) {
                if (resourceArnsListValue != null) {
                    request.addParameter("ResourceArns.member." + resourceArnsListIndex, StringUtils.fromString(resourceArnsListValue));
                }
                ++resourceArnsListIndex;
            }
        }
        if (simulatePrincipalPolicyRequest.resourcePolicy() != null) {
            request.addParameter("ResourcePolicy", StringUtils.fromString(simulatePrincipalPolicyRequest.resourcePolicy()));
        }
        if (simulatePrincipalPolicyRequest.resourceOwner() != null) {
            request.addParameter("ResourceOwner", StringUtils.fromString(simulatePrincipalPolicyRequest.resourceOwner()));
        }
        if (simulatePrincipalPolicyRequest.callerArn() != null) {
            request.addParameter("CallerArn", StringUtils.fromString(simulatePrincipalPolicyRequest.callerArn()));
        }
        if (!(contextEntriesList = (SdkInternalList)simulatePrincipalPolicyRequest.contextEntries()).isEmpty() || !contextEntriesList.isAutoConstruct()) {
            int contextEntriesListIndex = 1;
            for (ContextEntry contextEntriesListValue : contextEntriesList) {
                SdkInternalList contextKeyValuesList;
                if (contextEntriesListValue.contextKeyName() != null) {
                    request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyName", StringUtils.fromString(contextEntriesListValue.contextKeyName()));
                }
                if (!(contextKeyValuesList = (SdkInternalList)contextEntriesListValue.contextKeyValues()).isEmpty() || !contextKeyValuesList.isAutoConstruct()) {
                    int contextKeyValuesListIndex = 1;
                    for (String contextKeyValuesListValue : contextKeyValuesList) {
                        if (contextKeyValuesListValue != null) {
                            request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyValues.member." + contextKeyValuesListIndex, StringUtils.fromString(contextKeyValuesListValue));
                        }
                        ++contextKeyValuesListIndex;
                    }
                }
                if (contextEntriesListValue.contextKeyType() != null) {
                    request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyType", StringUtils.fromString(contextEntriesListValue.contextKeyType()));
                }
                ++contextEntriesListIndex;
            }
        }
        if (simulatePrincipalPolicyRequest.resourceHandlingOption() != null) {
            request.addParameter("ResourceHandlingOption", StringUtils.fromString(simulatePrincipalPolicyRequest.resourceHandlingOption()));
        }
        if (simulatePrincipalPolicyRequest.maxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger(simulatePrincipalPolicyRequest.maxItems()));
        }
        if (simulatePrincipalPolicyRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString(simulatePrincipalPolicyRequest.marker()));
        }
        return request;
    }
}

