/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.UpdateAccountPasswordPolicyRequest;
import software.amazon.awssdk.util.StringUtils;

public class UpdateAccountPasswordPolicyRequestMarshaller
implements Marshaller<Request<UpdateAccountPasswordPolicyRequest>, UpdateAccountPasswordPolicyRequest> {
    @Override
    public Request<UpdateAccountPasswordPolicyRequest> marshall(UpdateAccountPasswordPolicyRequest updateAccountPasswordPolicyRequest) {
        if (updateAccountPasswordPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateAccountPasswordPolicyRequest> request = new DefaultRequest<UpdateAccountPasswordPolicyRequest>(updateAccountPasswordPolicyRequest, "IAMClient");
        request.addParameter("Action", "UpdateAccountPasswordPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateAccountPasswordPolicyRequest.minimumPasswordLength() != null) {
            request.addParameter("MinimumPasswordLength", StringUtils.fromInteger(updateAccountPasswordPolicyRequest.minimumPasswordLength()));
        }
        if (updateAccountPasswordPolicyRequest.requireSymbols() != null) {
            request.addParameter("RequireSymbols", StringUtils.fromBoolean(updateAccountPasswordPolicyRequest.requireSymbols()));
        }
        if (updateAccountPasswordPolicyRequest.requireNumbers() != null) {
            request.addParameter("RequireNumbers", StringUtils.fromBoolean(updateAccountPasswordPolicyRequest.requireNumbers()));
        }
        if (updateAccountPasswordPolicyRequest.requireUppercaseCharacters() != null) {
            request.addParameter("RequireUppercaseCharacters", StringUtils.fromBoolean(updateAccountPasswordPolicyRequest.requireUppercaseCharacters()));
        }
        if (updateAccountPasswordPolicyRequest.requireLowercaseCharacters() != null) {
            request.addParameter("RequireLowercaseCharacters", StringUtils.fromBoolean(updateAccountPasswordPolicyRequest.requireLowercaseCharacters()));
        }
        if (updateAccountPasswordPolicyRequest.allowUsersToChangePassword() != null) {
            request.addParameter("AllowUsersToChangePassword", StringUtils.fromBoolean(updateAccountPasswordPolicyRequest.allowUsersToChangePassword()));
        }
        if (updateAccountPasswordPolicyRequest.maxPasswordAge() != null) {
            request.addParameter("MaxPasswordAge", StringUtils.fromInteger(updateAccountPasswordPolicyRequest.maxPasswordAge()));
        }
        if (updateAccountPasswordPolicyRequest.passwordReusePrevention() != null) {
            request.addParameter("PasswordReusePrevention", StringUtils.fromInteger(updateAccountPasswordPolicyRequest.passwordReusePrevention()));
        }
        if (updateAccountPasswordPolicyRequest.hardExpiry() != null) {
            request.addParameter("HardExpiry", StringUtils.fromBoolean(updateAccountPasswordPolicyRequest.hardExpiry()));
        }
        return request;
    }
}

