/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.UpdateGroupRequest;
import software.amazon.awssdk.util.StringUtils;

public class UpdateGroupRequestMarshaller
implements Marshaller<Request<UpdateGroupRequest>, UpdateGroupRequest> {
    @Override
    public Request<UpdateGroupRequest> marshall(UpdateGroupRequest updateGroupRequest) {
        if (updateGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateGroupRequest> request = new DefaultRequest<UpdateGroupRequest>(updateGroupRequest, "IAMClient");
        request.addParameter("Action", "UpdateGroup");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateGroupRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString(updateGroupRequest.groupName()));
        }
        if (updateGroupRequest.newPath() != null) {
            request.addParameter("NewPath", StringUtils.fromString(updateGroupRequest.newPath()));
        }
        if (updateGroupRequest.newGroupName() != null) {
            request.addParameter("NewGroupName", StringUtils.fromString(updateGroupRequest.newGroupName()));
        }
        return request;
    }
}

