/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.UpdateSAMLProviderRequest;
import software.amazon.awssdk.util.StringUtils;

public class UpdateSAMLProviderRequestMarshaller
implements Marshaller<Request<UpdateSAMLProviderRequest>, UpdateSAMLProviderRequest> {
    @Override
    public Request<UpdateSAMLProviderRequest> marshall(UpdateSAMLProviderRequest updateSAMLProviderRequest) {
        if (updateSAMLProviderRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateSAMLProviderRequest> request = new DefaultRequest<UpdateSAMLProviderRequest>(updateSAMLProviderRequest, "IAMClient");
        request.addParameter("Action", "UpdateSAMLProvider");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateSAMLProviderRequest.samlMetadataDocument() != null) {
            request.addParameter("SAMLMetadataDocument", StringUtils.fromString(updateSAMLProviderRequest.samlMetadataDocument()));
        }
        if (updateSAMLProviderRequest.samlProviderArn() != null) {
            request.addParameter("SAMLProviderArn", StringUtils.fromString(updateSAMLProviderRequest.samlProviderArn()));
        }
        return request;
    }
}

