/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.UploadSSHPublicKeyRequest;
import software.amazon.awssdk.util.StringUtils;

public class UploadSSHPublicKeyRequestMarshaller
implements Marshaller<Request<UploadSSHPublicKeyRequest>, UploadSSHPublicKeyRequest> {
    @Override
    public Request<UploadSSHPublicKeyRequest> marshall(UploadSSHPublicKeyRequest uploadSSHPublicKeyRequest) {
        if (uploadSSHPublicKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UploadSSHPublicKeyRequest> request = new DefaultRequest<UploadSSHPublicKeyRequest>(uploadSSHPublicKeyRequest, "IAMClient");
        request.addParameter("Action", "UploadSSHPublicKey");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (uploadSSHPublicKeyRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString(uploadSSHPublicKeyRequest.userName()));
        }
        if (uploadSSHPublicKeyRequest.sshPublicKeyBody() != null) {
            request.addParameter("SSHPublicKeyBody", StringUtils.fromString(uploadSSHPublicKeyRequest.sshPublicKeyBody()));
        }
        return request;
    }
}

