/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.UploadSigningCertificateRequest;
import software.amazon.awssdk.util.StringUtils;

public class UploadSigningCertificateRequestMarshaller
implements Marshaller<Request<UploadSigningCertificateRequest>, UploadSigningCertificateRequest> {
    @Override
    public Request<UploadSigningCertificateRequest> marshall(UploadSigningCertificateRequest uploadSigningCertificateRequest) {
        if (uploadSigningCertificateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UploadSigningCertificateRequest> request = new DefaultRequest<UploadSigningCertificateRequest>(uploadSigningCertificateRequest, "IAMClient");
        request.addParameter("Action", "UploadSigningCertificate");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (uploadSigningCertificateRequest.userName() != null) {
            request.addParameter("UserName", StringUtils.fromString(uploadSigningCertificateRequest.userName()));
        }
        if (uploadSigningCertificateRequest.certificateBody() != null) {
            request.addParameter("CertificateBody", StringUtils.fromString(uploadSigningCertificateRequest.certificateBody()));
        }
        return request;
    }
}

