/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.iam.IAMClient;
import software.amazon.awssdk.services.iam.model.GetInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.GetInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.GetUserRequest;
import software.amazon.awssdk.services.iam.model.GetUserResponse;
import software.amazon.awssdk.services.iam.waiters.GetInstanceProfileFunction;
import software.amazon.awssdk.services.iam.waiters.GetUserFunction;
import software.amazon.awssdk.services.iam.waiters.UserExists;
import software.amazon.awssdk.waiters.FixedDelayStrategy;
import software.amazon.awssdk.waiters.HttpFailureStatusAcceptor;
import software.amazon.awssdk.waiters.HttpSuccessStatusAcceptor;
import software.amazon.awssdk.waiters.MaxAttemptsRetryStrategy;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterBuilder;
import software.amazon.awssdk.waiters.WaiterState;

public class IAMClientWaiters {
    private final IAMClient client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public IAMClientWaiters(IAMClient client) {
        this.client = client;
    }

    public Waiter<GetInstanceProfileRequest> instanceProfileExists() {
        return new WaiterBuilder<GetInstanceProfileRequest, GetInstanceProfileResponse>().withSdkFunction(new GetInstanceProfileFunction(this.client)).withAcceptors(new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new HttpFailureStatusAcceptor(404, WaiterState.RETRY)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(1))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetUserRequest> userExists() {
        return new WaiterBuilder<GetUserRequest, GetUserResponse>().withSdkFunction(new GetUserFunction(this.client)).withAcceptors(new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new UserExists.IsNoSuchEntityMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(1))).withExecutorService(this.executorService).build();
    }
}

