/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kms.transform.AliasListEntryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AliasListEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, AliasListEntry> {
    private final String aliasName;
    private final String aliasArn;
    private final String targetKeyId;

    private AliasListEntry(BuilderImpl builder) {
        this.aliasName = builder.aliasName;
        this.aliasArn = builder.aliasArn;
        this.targetKeyId = builder.targetKeyId;
    }

    public String aliasName() {
        return this.aliasName;
    }

    public String aliasArn() {
        return this.aliasArn;
    }

    public String targetKeyId() {
        return this.targetKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.aliasName() == null ? 0 : this.aliasName().hashCode());
        hashCode = 31 * hashCode + (this.aliasArn() == null ? 0 : this.aliasArn().hashCode());
        hashCode = 31 * hashCode + (this.targetKeyId() == null ? 0 : this.targetKeyId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AliasListEntry)) {
            return false;
        }
        AliasListEntry other = (AliasListEntry)obj;
        if (other.aliasName() == null ^ this.aliasName() == null) {
            return false;
        }
        if (other.aliasName() != null && !other.aliasName().equals(this.aliasName())) {
            return false;
        }
        if (other.aliasArn() == null ^ this.aliasArn() == null) {
            return false;
        }
        if (other.aliasArn() != null && !other.aliasArn().equals(this.aliasArn())) {
            return false;
        }
        if (other.targetKeyId() == null ^ this.targetKeyId() == null) {
            return false;
        }
        return other.targetKeyId() == null || other.targetKeyId().equals(this.targetKeyId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.aliasName() != null) {
            sb.append("AliasName: ").append(this.aliasName()).append(",");
        }
        if (this.aliasArn() != null) {
            sb.append("AliasArn: ").append(this.aliasArn()).append(",");
        }
        if (this.targetKeyId() != null) {
            sb.append("TargetKeyId: ").append(this.targetKeyId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AliasListEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String aliasName;
        private String aliasArn;
        private String targetKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(AliasListEntry model) {
            this.setAliasName(model.aliasName);
            this.setAliasArn(model.aliasArn);
            this.setTargetKeyId(model.targetKeyId);
        }

        public final String getAliasName() {
            return this.aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        public final String getAliasArn() {
            return this.aliasArn;
        }

        @Override
        public final Builder aliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
            return this;
        }

        public final void setAliasArn(String aliasArn) {
            this.aliasArn = aliasArn;
        }

        public final String getTargetKeyId() {
            return this.targetKeyId;
        }

        @Override
        public final Builder targetKeyId(String targetKeyId) {
            this.targetKeyId = targetKeyId;
            return this;
        }

        public final void setTargetKeyId(String targetKeyId) {
            this.targetKeyId = targetKeyId;
        }

        @Override
        public AliasListEntry build() {
            return new AliasListEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AliasListEntry> {
        public Builder aliasName(String var1);

        public Builder aliasArn(String var1);

        public Builder targetKeyId(String var1);
    }
}

