/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateAliasRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateAliasRequest> {
    private final String aliasName;
    private final String targetKeyId;

    private CreateAliasRequest(BuilderImpl builder) {
        this.aliasName = builder.aliasName;
        this.targetKeyId = builder.targetKeyId;
    }

    public String aliasName() {
        return this.aliasName;
    }

    public String targetKeyId() {
        return this.targetKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.aliasName() == null ? 0 : this.aliasName().hashCode());
        hashCode = 31 * hashCode + (this.targetKeyId() == null ? 0 : this.targetKeyId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAliasRequest)) {
            return false;
        }
        CreateAliasRequest other = (CreateAliasRequest)obj;
        if (other.aliasName() == null ^ this.aliasName() == null) {
            return false;
        }
        if (other.aliasName() != null && !other.aliasName().equals(this.aliasName())) {
            return false;
        }
        if (other.targetKeyId() == null ^ this.targetKeyId() == null) {
            return false;
        }
        return other.targetKeyId() == null || other.targetKeyId().equals(this.targetKeyId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.aliasName() != null) {
            sb.append("AliasName: ").append(this.aliasName()).append(",");
        }
        if (this.targetKeyId() != null) {
            sb.append("TargetKeyId: ").append(this.targetKeyId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String aliasName;
        private String targetKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAliasRequest model) {
            this.setAliasName(model.aliasName);
            this.setTargetKeyId(model.targetKeyId);
        }

        public final String getAliasName() {
            return this.aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        public final String getTargetKeyId() {
            return this.targetKeyId;
        }

        @Override
        public final Builder targetKeyId(String targetKeyId) {
            this.targetKeyId = targetKeyId;
            return this;
        }

        public final void setTargetKeyId(String targetKeyId) {
            this.targetKeyId = targetKeyId;
        }

        @Override
        public CreateAliasRequest build() {
            return new CreateAliasRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateAliasRequest> {
        public Builder aliasName(String var1);

        public Builder targetKeyId(String var1);
    }
}

