/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.nio.ByteBuffer;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GenerateRandomResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GenerateRandomResponse> {
    private final ByteBuffer plaintext;

    private GenerateRandomResponse(BuilderImpl builder) {
        this.plaintext = builder.plaintext;
    }

    public ByteBuffer plaintext() {
        return this.plaintext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.plaintext() == null ? 0 : this.plaintext().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateRandomResponse)) {
            return false;
        }
        GenerateRandomResponse other = (GenerateRandomResponse)obj;
        if (other.plaintext() == null ^ this.plaintext() == null) {
            return false;
        }
        return other.plaintext() == null || other.plaintext().equals(this.plaintext());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.plaintext() != null) {
            sb.append("Plaintext: ").append(this.plaintext()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private ByteBuffer plaintext;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateRandomResponse model) {
            this.setPlaintext(model.plaintext);
        }

        public final ByteBuffer getPlaintext() {
            return this.plaintext;
        }

        @Override
        public final Builder plaintext(ByteBuffer plaintext) {
            this.plaintext = StandardMemberCopier.copy(plaintext);
            return this;
        }

        public final void setPlaintext(ByteBuffer plaintext) {
            this.plaintext = StandardMemberCopier.copy(plaintext);
        }

        @Override
        public GenerateRandomResponse build() {
            return new GenerateRandomResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GenerateRandomResponse> {
        public Builder plaintext(ByteBuffer var1);
    }
}

