/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kms.transform.KeyListEntryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class KeyListEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, KeyListEntry> {
    private final String keyId;
    private final String keyArn;

    private KeyListEntry(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.keyArn = builder.keyArn;
    }

    public String keyId() {
        return this.keyId;
    }

    public String keyArn() {
        return this.keyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.keyId() == null ? 0 : this.keyId().hashCode());
        hashCode = 31 * hashCode + (this.keyArn() == null ? 0 : this.keyArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyListEntry)) {
            return false;
        }
        KeyListEntry other = (KeyListEntry)obj;
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.keyArn() == null ^ this.keyArn() == null) {
            return false;
        }
        return other.keyArn() == null || other.keyArn().equals(this.keyArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (this.keyArn() != null) {
            sb.append("KeyArn: ").append(this.keyArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeyListEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String keyId;
        private String keyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyListEntry model) {
            this.setKeyId(model.keyId);
            this.setKeyArn(model.keyArn);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final String getKeyArn() {
            return this.keyArn;
        }

        @Override
        public final Builder keyArn(String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        public final void setKeyArn(String keyArn) {
            this.keyArn = keyArn;
        }

        @Override
        public KeyListEntry build() {
            return new KeyListEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KeyListEntry> {
        public Builder keyId(String var1);

        public Builder keyArn(String var1);
    }
}

