/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.kms.model.KeyListCopier;
import software.amazon.awssdk.services.kms.model.KeyListEntry;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListKeysResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListKeysResponse> {
    private final List<KeyListEntry> keys;
    private final String nextMarker;
    private final Boolean truncated;

    private ListKeysResponse(BuilderImpl builder) {
        this.keys = builder.keys;
        this.nextMarker = builder.nextMarker;
        this.truncated = builder.truncated;
    }

    public List<KeyListEntry> keys() {
        return this.keys;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Boolean truncated() {
        return this.truncated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.keys() == null ? 0 : this.keys().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        hashCode = 31 * hashCode + (this.truncated() == null ? 0 : this.truncated().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKeysResponse)) {
            return false;
        }
        ListKeysResponse other = (ListKeysResponse)obj;
        if (other.keys() == null ^ this.keys() == null) {
            return false;
        }
        if (other.keys() != null && !other.keys().equals(this.keys())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.truncated() == null ^ this.truncated() == null) {
            return false;
        }
        return other.truncated() == null || other.truncated().equals(this.truncated());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.keys() != null) {
            sb.append("Keys: ").append(this.keys()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.truncated() != null) {
            sb.append("Truncated: ").append(this.truncated()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<KeyListEntry> keys = new SdkInternalList<KeyListEntry>();
        private String nextMarker;
        private Boolean truncated;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKeysResponse model) {
            this.setKeys(model.keys);
            this.setNextMarker(model.nextMarker);
            this.setTruncated(model.truncated);
        }

        public final Collection<KeyListEntry> getKeys() {
            return this.keys;
        }

        @Override
        public final Builder keys(Collection<KeyListEntry> keys) {
            this.keys = KeyListCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(KeyListEntry ... keys) {
            if (this.keys == null) {
                this.keys = new SdkInternalList<KeyListEntry>(keys.length);
            }
            for (KeyListEntry e : keys) {
                this.keys.add(e);
            }
            return this;
        }

        public final void setKeys(Collection<KeyListEntry> keys) {
            this.keys = KeyListCopier.copy(keys);
        }

        @SafeVarargs
        public final void setKeys(KeyListEntry ... keys) {
            if (this.keys == null) {
                this.keys = new SdkInternalList<KeyListEntry>(keys.length);
            }
            for (KeyListEntry e : keys) {
                this.keys.add(e);
            }
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Boolean getTruncated() {
            return this.truncated;
        }

        @Override
        public final Builder truncated(Boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        public final void setTruncated(Boolean truncated) {
            this.truncated = truncated;
        }

        @Override
        public ListKeysResponse build() {
            return new ListKeysResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListKeysResponse> {
        public Builder keys(Collection<KeyListEntry> var1);

        public Builder keys(KeyListEntry ... var1);

        public Builder nextMarker(String var1);

        public Builder truncated(Boolean var1);
    }
}

