/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ScheduleKeyDeletionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ScheduleKeyDeletionRequest> {
    private final String keyId;
    private final Integer pendingWindowInDays;

    private ScheduleKeyDeletionRequest(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.pendingWindowInDays = builder.pendingWindowInDays;
    }

    public String keyId() {
        return this.keyId;
    }

    public Integer pendingWindowInDays() {
        return this.pendingWindowInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.keyId() == null ? 0 : this.keyId().hashCode());
        hashCode = 31 * hashCode + (this.pendingWindowInDays() == null ? 0 : this.pendingWindowInDays().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleKeyDeletionRequest)) {
            return false;
        }
        ScheduleKeyDeletionRequest other = (ScheduleKeyDeletionRequest)obj;
        if (other.keyId() == null ^ this.keyId() == null) {
            return false;
        }
        if (other.keyId() != null && !other.keyId().equals(this.keyId())) {
            return false;
        }
        if (other.pendingWindowInDays() == null ^ this.pendingWindowInDays() == null) {
            return false;
        }
        return other.pendingWindowInDays() == null || other.pendingWindowInDays().equals(this.pendingWindowInDays());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.keyId() != null) {
            sb.append("KeyId: ").append(this.keyId()).append(",");
        }
        if (this.pendingWindowInDays() != null) {
            sb.append("PendingWindowInDays: ").append(this.pendingWindowInDays()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String keyId;
        private Integer pendingWindowInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleKeyDeletionRequest model) {
            this.setKeyId(model.keyId);
            this.setPendingWindowInDays(model.pendingWindowInDays);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final Integer getPendingWindowInDays() {
            return this.pendingWindowInDays;
        }

        @Override
        public final Builder pendingWindowInDays(Integer pendingWindowInDays) {
            this.pendingWindowInDays = pendingWindowInDays;
            return this;
        }

        public final void setPendingWindowInDays(Integer pendingWindowInDays) {
            this.pendingWindowInDays = pendingWindowInDays;
        }

        @Override
        public ScheduleKeyDeletionRequest build() {
            return new ScheduleKeyDeletionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScheduleKeyDeletionRequest> {
        public Builder keyId(String var1);

        public Builder pendingWindowInDays(Integer var1);
    }
}

