/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kms.model.CreateGrantRequest;

@SdkInternalApi
public class CreateGrantRequestModelMarshaller {
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").build();
    private static final MarshallingInfo<String> GRANTEEPRINCIPAL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GranteePrincipal").build();
    private static final MarshallingInfo<String> RETIRINGPRINCIPAL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetiringPrincipal").build();
    private static final MarshallingInfo<List> OPERATIONS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Operations").build();
    private static final MarshallingInfo<StructuredPojo> CONSTRAINTS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Constraints").build();
    private static final MarshallingInfo<List> GRANTTOKENS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrantTokens").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final CreateGrantRequestModelMarshaller instance = new CreateGrantRequestModelMarshaller();

    public static CreateGrantRequestModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(CreateGrantRequest createGrantRequest, ProtocolMarshaller protocolMarshaller) {
        if (createGrantRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(createGrantRequest.keyId(), KEYID_BINDING);
            protocolMarshaller.marshall(createGrantRequest.granteePrincipal(), GRANTEEPRINCIPAL_BINDING);
            protocolMarshaller.marshall(createGrantRequest.retiringPrincipal(), RETIRINGPRINCIPAL_BINDING);
            protocolMarshaller.marshall(createGrantRequest.operations(), OPERATIONS_BINDING);
            protocolMarshaller.marshall(createGrantRequest.constraints(), CONSTRAINTS_BINDING);
            protocolMarshaller.marshall(createGrantRequest.grantTokens(), GRANTTOKENS_BINDING);
            protocolMarshaller.marshall(createGrantRequest.name(), NAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

