/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.nio.ByteBuffer;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kms.model.DecryptResponse;

public class DecryptResponseUnmarshaller
implements Unmarshaller<DecryptResponse, JsonUnmarshallerContext> {
    private static DecryptResponseUnmarshaller INSTANCE;

    @Override
    public DecryptResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        DecryptResponse.Builder decryptResponseBuilder = DecryptResponse.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return (DecryptResponse)decryptResponseBuilder.build();
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("KeyId", targetDepth)) {
                    context.nextToken();
                    decryptResponseBuilder.keyId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Plaintext", targetDepth)) {
                    context.nextToken();
                    decryptResponseBuilder.plaintext(context.getUnmarshaller(ByteBuffer.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DecryptResponse)decryptResponseBuilder.build();
    }

    public static DecryptResponseUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DecryptResponseUnmarshaller();
        }
        return INSTANCE;
    }
}

